/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketPropertyPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWWorkBasketPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    protected VWSessionInfo m_sessionInfo = null;
    protected boolean m_bIsModified = false;
    protected VWToolbarBorder m_workBasketsToolBar = null;
    protected VWTable m_workBasketTable = null;
    protected VWWorkBasketTableModel m_workBasketTableModel = null;
    protected VWWorkBasketPropertyPanel m_workBasketPropertyPanel = null;
    private static final double s_defaultHSplitRatio = 0.25;
    private static final double s_defaultHSplitRatio_bidi = 0.7;

    public VWWorkBasketPanel(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.createControls();
        this.onSelectedWorkBasket();
    }

    public void setQueueDefinition(VWQueueDefinition queueDef) {
        if (this.m_workBasketTableModel != null) {
            this.m_workBasketTableModel.setQueueDefinition(queueDef);
        }
        if (this.m_workBasketPropertyPanel != null) {
            this.m_workBasketPropertyPanel.setQueueDefinition(queueDef);
        }
        this.setEnabled(queueDef != null);
        if (this.m_workBasketTable != null && this.m_workBasketTableModel != null && this.m_workBasketTableModel.getRowCount() > 0) {
            this.m_workBasketTable.setRowSelectionInterval(0, 0);
        }
    }

    public VWQueueDefinition getQueueDefinition() {
        if (this.m_workBasketTableModel != null) {
            return this.m_workBasketTableModel.getQueueDefinition();
        }
        return null;
    }

    public void setEnabled(boolean bEnabled) {
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        this.m_workBasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketsToolBar.getClientPanel(), nButtonState, nButtons));
        if (bEnabled) {
            nButtonState = 1;
            nButtons = 16;
            if (this.m_workBasketTable.getSelectedRow() != -1) {
                nButtons |= 0x10000040;
            }
            this.m_workBasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketsToolBar.getClientPanel(), nButtonState, nButtons));
        }
        this.m_workBasketTable.setEnabled(bEnabled);
        this.m_workBasketPropertyPanel.setEnabled(this.m_workBasketTableModel.getRowCount() > 0);
    }

    public boolean isModified() {
        this.stopEditing();
        if (this.m_workBasketTableModel != null && this.m_workBasketTableModel.isModified()) {
            return true;
        }
        if (this.m_workBasketPropertyPanel != null && this.m_workBasketPropertyPanel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    public void resetModifiedFlag() {
        if (this.m_workBasketTableModel != null) {
            this.m_workBasketTableModel.resetModifiedFlag();
        }
        if (this.m_workBasketPropertyPanel != null) {
            this.m_workBasketPropertyPanel.resetModifiedFlag();
        }
        this.m_bIsModified = false;
    }

    public void checkForErrors() throws Exception {
        if (this.m_workBasketTableModel == null || this.m_workBasketPropertyPanel == null) {
            return;
        }
        for (int nRowIndex = 0; nRowIndex < this.m_workBasketTableModel.getRowCount(); ++nRowIndex) {
            this.m_workBasketTable.clearSelection();
            this.m_workBasketTable.setRowSelectionInterval(nRowIndex, nRowIndex);
            this.m_workBasketPropertyPanel.checkForErrors();
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_workBasketTable.getRowCount() - 1) {
                    nRow = this.m_workBasketTable.getRowCount() - 1;
                }
                if (nRow == -1) {
                    return;
                }
                if (nRow == this.m_workBasketTable.getSelectedRow()) {
                    this.m_workBasketTable.clearSelection();
                }
                this.m_workBasketTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != 0) break;
                this.onSelectedWorkBasket();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_workBasketTable.getSelectionModel())) {
                this.onSelectedWorkBasket();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource() == this.m_workBasketsToolBar) {
                switch (event.getID()) {
                    case 16: {
                        this.m_workBasketTableModel.addNewWorkBasket();
                        break;
                    }
                    case 64: {
                        int nRowIndex = this.m_workBasketTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketTableModel.copyWorkBasketAtIndex(nRowIndex);
                        break;
                    }
                    case 0x10000000: {
                        int nRowIndex = this.m_workBasketTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_workBasketTableModel.deleteWorkBasketAtIndex(nRowIndex);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void createControls() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JPanel leftPanel = this.createWorkBasketTablePanel();
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_workBasketPropertyPanel = new VWWorkBasketPropertyPanel(this.m_sessionInfo, true);
            VWSplitPane splitPane = null;
            if (compOrientation.isLeftToRight()) {
                splitPane = new VWSplitPane(1, leftPanel, this.m_workBasketPropertyPanel);
                splitPane.setDividerLocation(0.25);
            } else {
                splitPane = new VWSplitPane(1, this.m_workBasketPropertyPanel, leftPanel);
                splitPane.setDividerLocation(0.7);
            }
            splitPane.setResizeWeight(0.25);
            this.add((Component)splitPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createWorkBasketTablePanel() {
        try {
            JPanel workBasketTablePanel = new JPanel(new BorderLayout(6, 6));
            workBasketTablePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_workBasketsToolBar = new VWToolbarBorder(VWResource.Inbaskets, 0x10000050, VWResource.Inbaskets);
            this.m_workBasketsToolBar.setToolbarBackground(this.getBackground());
            this.m_workBasketsToolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketsToolBar, this, VWResource.Inbaskets, VWResource.Inbaskets);
            JPanel childPanel = this.m_workBasketsToolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_workBasketTableModel = new VWWorkBasketTableModel(this.m_sessionInfo);
            this.m_workBasketTableModel.addTableModelListener(this);
            this.m_workBasketTable = new VWTable(this.m_workBasketTableModel);
            this.m_workBasketTable.setRowSelectionAllowed(true);
            this.m_workBasketTable.getSelectionModel().setSelectionMode(0);
            this.m_workBasketTable.getSelectionModel().addListSelectionListener(this);
            this.m_workBasketTable.setShowGrid(false);
            this.m_workBasketTable.setTableHeader(null);
            this.m_workBasketTable.setRowHeight(26);
            this.m_workBasketTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_workBasketTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            VWAccessibilityHelper.setAccessibility(this.m_workBasketTable, this, VWResource.InbasketsTable, VWResource.InbasketsTable);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.Inbaskets), this.m_workBasketTable);
            childPanel.add((Component)new JScrollPane(this.m_workBasketTable), "Center");
            workBasketTablePanel.add((Component)this.m_workBasketsToolBar, "Center");
            return workBasketTablePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void stopEditing() {
        if (this.m_workBasketTable != null) {
            this.m_workBasketTable.stopEditing();
        }
        if (this.m_workBasketPropertyPanel != null) {
            this.m_workBasketPropertyPanel.stopEditing();
        }
    }

    protected void releaseResources() {
        if (this.m_workBasketsToolBar != null) {
            this.m_workBasketsToolBar.releaseResources();
            this.m_workBasketsToolBar = null;
        }
        if (this.m_workBasketTable != null) {
            this.m_workBasketTable.removeAll();
            this.m_workBasketTable = null;
        }
        if (this.m_workBasketTableModel != null) {
            this.m_workBasketTableModel.releaseResources();
            this.m_workBasketTableModel = null;
        }
        if (this.m_workBasketPropertyPanel != null) {
            this.m_workBasketPropertyPanel.releaseResources();
            this.m_workBasketPropertyPanel = null;
        }
        this.m_sessionInfo = null;
        this.removeAll();
    }

    private void onSelectedWorkBasket() {
        try {
            int nRowIndex = this.m_workBasketTable.getSelectedRow();
            int nButtons = 0x10000040;
            if (nRowIndex == -1) {
                this.m_workBasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketsToolBar.getClientPanel(), 2, nButtons));
            } else {
                this.m_workBasketsToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_workBasketsToolBar.getClientPanel(), 1, nButtons));
            }
            if (this.m_workBasketPropertyPanel != null) {
                this.m_workBasketPropertyPanel.stopEditing();
                if (this.m_workBasketPropertyPanel.isModified()) {
                    this.m_bIsModified = true;
                }
                this.m_workBasketPropertyPanel.setWorkBasketDefinition(this.m_workBasketTableModel.getRowItemAt(nRowIndex));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

